/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui.citizen;

import com.ldtteam.blockui.Alignment;
import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneBuilders;
import com.ldtteam.blockui.controls.AbstractTextBuilder;
import com.ldtteam.blockui.controls.Image;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.View;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.util.constant.WindowConstants;
import com.minecolonies.coremod.client.gui.AbstractWindowSkeleton;
import com.minecolonies.coremod.client.gui.citizen.JobWindowCitizen;
import com.minecolonies.coremod.client.gui.modules.WindowBuilderResModule;
import com.minecolonies.coremod.colony.buildings.moduleviews.WorkerBuildingModuleView;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import org.jetbrains.annotations.NotNull;

public class CitizenWindowUtils {
    private CitizenWindowUtils() {
    }

    public static void createHealthBar(ICitizenDataView citizen, View healthBarView) {
        int health = (int)citizen.getHealth();
        CitizenWindowUtils.createHealthBar(health, healthBarView);
    }

    public static void createHealthBar(int health, View healthBarView) {
        healthBarView.setAlignment(Alignment.MIDDLE_RIGHT);
        ((Text)healthBarView.findPaneOfTypeByID("healthLabel", Text.class)).setText(Integer.toString(health / 2));
        for (int i = 0; i < 10; ++i) {
            CitizenWindowUtils.addHeart(healthBarView, i, HeartsEnum.EMPTY);
        }
        int heartPos = 0;
        ArrayList<HeartsEnum> heartList = new ArrayList<HeartsEnum>();
        heartList.add(HeartsEnum.BLUE);
        heartList.add(HeartsEnum.GREEN);
        heartList.add(HeartsEnum.GOLDEN);
        heartList.add(HeartsEnum.RED);
        for (HeartsEnum heart : heartList) {
            if (heart.isHalfHeart || heart.prevHeart == null) continue;
            for (int i = heartPos; i < 10 && health > heart.prevHeart.hpValue * 10 + 1; ++i) {
                CitizenWindowUtils.addHeart(healthBarView, heartPos, heart);
                health -= heart.hpValue - heart.prevHeart.hpValue;
                ++heartPos;
            }
            if (health % 2 == 1 && heartPos < 10 && heart.halfHeart != null && health > heart.prevHeart.hpValue * 10) {
                CitizenWindowUtils.addHeart(healthBarView, heartPos, heart.prevHeart);
                CitizenWindowUtils.addHeart(healthBarView, heartPos, heart.halfHeart);
                health -= heart.halfHeart.hpValue - heart.prevHeart.hpValue;
                ++heartPos;
            }
            if (heartPos < 10) continue;
            return;
        }
    }

    private static void addHeart(View healthBarView, int heartPos, HeartsEnum heart) {
        @NotNull Image heartImage = new Image();
        heartImage.setImage(heart.Image, heart.X, heart.Y, 9, 9);
        heartImage.setMapDimensions(256, 256);
        heartImage.setSize(9, 9);
        heartImage.setPosition(heartPos * 10 + 10, 10);
        healthBarView.addChild((Pane)heartImage);
    }

    private static int getYOffset(int i) {
        return i >= 10 ? 10 : 0;
    }

    private static int getXOffsetModifier(int i) {
        return i >= 10 ? i - 10 : i;
    }

    public static void createSaturationBar(ICitizenDataView citizen, View view) {
        CitizenWindowUtils.createSaturationBar(citizen.getSaturation(), view);
    }

    public static void createSaturationBar(double curSaturation, View view) {
        int saturationPos;
        Image saturation;
        ((View)view.findPaneOfTypeByID("saturationBar", View.class)).setAlignment(Alignment.MIDDLE_RIGHT);
        for (int i = 0; i < 20; ++i) {
            saturation = new Image();
            saturation.setImage(Screen.f_93098_, 16, 27, 9, 9);
            saturation.setMapDimensions(256, 256);
            saturation.setSize(9, 9);
            saturation.setPosition(CitizenWindowUtils.getXOffsetModifier(i) * 10 + 10, 10 + CitizenWindowUtils.getYOffset(i));
            ((View)view.findPaneOfTypeByID("saturationBar", View.class)).addChild((Pane)saturation);
        }
        for (saturationPos = 0; saturationPos < (int)curSaturation; ++saturationPos) {
            saturation = new Image();
            saturation.setImage(Screen.f_93098_, 52, 27, 9, 9);
            saturation.setMapDimensions(256, 256);
            saturation.setSize(9, 9);
            saturation.setPosition(CitizenWindowUtils.getXOffsetModifier(saturationPos) * 10 + 10, 10 + CitizenWindowUtils.getYOffset(saturationPos));
            ((View)view.findPaneOfTypeByID("saturationBar", View.class)).addChild((Pane)saturation);
        }
        if (curSaturation / 2.0 % 1.0 > 0.0) {
            saturation = new Image();
            saturation.setImage(Screen.f_93098_, 61, 27, 9, 9);
            saturation.setMapDimensions(256, 256);
            saturation.setSize(9, 9);
            saturation.setPosition(CitizenWindowUtils.getXOffsetModifier(saturationPos) * 10 + 10, 10 + CitizenWindowUtils.getYOffset(saturationPos));
            ((View)view.findPaneOfTypeByID("saturationBar", View.class)).addChild((Pane)saturation);
        }
    }

    public static void createHappinessBar(ICitizenDataView citizen, AbstractWindowSkeleton window) {
        double experienceRatio = citizen.getHappiness() / 10.0 * 91.0;
        ((View)window.findPaneOfTypeByID("happinessBar", View.class)).setAlignment(Alignment.MIDDLE_RIGHT);
        ((Text)window.findPaneOfTypeByID("happinessLabel", Text.class)).setText(Integer.toString((int)citizen.getHappiness()));
        @NotNull Image xpBar = new Image();
        xpBar.setImage(Screen.f_93098_, 0, 74, 91, 5);
        xpBar.setMapDimensions(256, 256);
        xpBar.setSize(91, 5);
        xpBar.setPosition(10, 10);
        @NotNull Image xpBar2 = new Image();
        xpBar2.setImage(Screen.f_93098_, 172, 74, 10, 5);
        xpBar2.setMapDimensions(256, 256);
        xpBar2.setSize(10, 5);
        xpBar2.setPosition(100, 10);
        ((View)window.findPaneOfTypeByID("happinessBar", View.class)).addChild((Pane)xpBar);
        ((View)window.findPaneOfTypeByID("happinessBar", View.class)).addChild((Pane)xpBar2);
        if (experienceRatio > 0.0) {
            @NotNull Image xpBarFull = new Image();
            xpBarFull.setImage(Screen.f_93098_, 0, 79, (int)experienceRatio, 5);
            xpBarFull.setMapDimensions(256, 256);
            xpBarFull.setSize((int)experienceRatio, 5);
            xpBarFull.setPosition(10, 10);
            ((View)window.findPaneOfTypeByID("happinessBar", View.class)).addChild((Pane)xpBarFull);
        }
    }

    public static void createSkillContent(ICitizenDataView citizen, AbstractWindowSkeleton window) {
        boolean isCreative = Minecraft.m_91087_().f_91074_.m_7500_();
        for (Map.Entry<Skill, Tuple<Integer, Double>> entry : citizen.getCitizenSkillHandler().getSkills().entrySet()) {
            String id = entry.getKey().name().toLowerCase(Locale.US);
            ((Text)window.findPaneOfTypeByID(id, Text.class)).setText((MutableComponent)new TextComponent(Integer.toString((Integer)entry.getValue().m_14418_())));
            Pane buttons = window.findPaneByID(id + "_bts");
            if (buttons == null) continue;
            buttons.setEnabled(isCreative);
        }
    }

    public static void updateHappiness(ICitizenDataView citizen, AbstractWindowSkeleton window) {
        ((Text)window.findPaneOfTypeByID("happinessModifier", Text.class)).setText((MutableComponent)new TranslatableComponent("com.minecolonies.coremod.gui.happiness.happinessmodifier"));
        int yPos = 62;
        for (String name : citizen.getHappinessHandler().getModifiers()) {
            double value = citizen.getHappinessHandler().getModifier(name).getFactor();
            Image image = new Image();
            image.setSize(11, 11);
            image.setPosition(45, yPos);
            window.addChild((Pane)image);
            Text label = new Text();
            label.setSize(136, 11);
            label.setPosition(70, yPos);
            label.setColors(WindowBuilderResModule.BLACK);
            label.setText((MutableComponent)new TranslatableComponent("com.minecolonies.coremod.gui.townhall.happiness." + name));
            window.addChild((Pane)label);
            ((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().hoverPane((Pane)label).append((MutableComponent)new TranslatableComponent("com.minecolonies.coremod.gui.townhall.happiness.desc." + name))).build();
            if (value > 1.0) {
                image.setImage(new ResourceLocation("minecolonies:textures/gui/green_icon.png"), false);
                ((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().append((MutableComponent)new TranslatableComponent("com.minecolonies.coremod.gui.happiness.positive"))).hoverPane((Pane)image).build();
            } else if (value == 1.0) {
                image.setImage(new ResourceLocation("minecolonies:textures/gui/blue_icon.png"), false);
                ((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().append((MutableComponent)new TranslatableComponent("com.minecolonies.coremod.gui.happiness.neutral"))).hoverPane((Pane)image).build();
            } else if (value > 0.75) {
                image.setImage(new ResourceLocation("minecolonies:textures/gui/yellow_icon.png"), false);
                ((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().append((MutableComponent)new TranslatableComponent("com.minecolonies.coremod.gui.happiness.slightlynegative"))).hoverPane((Pane)image).build();
            } else {
                image.setImage(new ResourceLocation("minecolonies:textures/gui/red_icon.png"), false);
                ((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().append((MutableComponent)new TranslatableComponent("com.minecolonies.coremod.gui.happiness.negative"))).hoverPane((Pane)image).build();
            }
            yPos += 12;
        }
    }

    public static void updateJobPage(ICitizenDataView citizen, JobWindowCitizen windowCitizen, IColonyView colony) {
        IBuildingView building = colony.getBuilding(citizen.getWorkBuilding());
        if (building instanceof AbstractBuildingView && building.getBuildingType() != ModBuildings.library && citizen.getJobView() != null) {
            WorkerBuildingModuleView moduleView = building.getModuleViewMatching(WorkerBuildingModuleView.class, m -> m.getJobEntry() == citizen.getJobView().getEntry());
            if (moduleView == null) {
                return;
            }
            ((Text)windowCitizen.findPaneOfTypeByID("jobLabel", Text.class)).setText((MutableComponent)new TranslatableComponent("com.minecolonies.coremod.gui.citizen.job.label", new Object[]{new TranslatableComponent(citizen.getJob())}));
            ((Text)windowCitizen.findPaneOfTypeByID("skillexplanation", Text.class)).setText((MutableComponent)new TranslatableComponent("com.minecolonies.coremod.gui.citizen.job.desc"));
            Skill primary = moduleView.getPrimarySkill();
            ((Text)windowCitizen.findPaneOfTypeByID("primary", Text.class)).setText(new TranslatableComponent("com.minecolonies.coremod.gui.citizen.job.skills." + primary.name().toLowerCase(Locale.US)).m_130946_(" (100% XP)"));
            ((Image)windowCitizen.findPaneOfTypeByID("primaryimg", Image.class)).setImage(new ResourceLocation("minecolonies:textures/entity/skills/small/" + primary.name().toLowerCase(Locale.US) + ".png"), false);
            if (primary.getComplimentary() != null && primary.getAdverse() != null) {
                ((Text)windowCitizen.findPaneOfTypeByID("comp1", Text.class)).setText(new TranslatableComponent("com.minecolonies.coremod.gui.citizen.job.skills." + primary.getComplimentary().name().toLowerCase(Locale.US)).m_130946_(" (10% XP)"));
                ((Image)windowCitizen.findPaneOfTypeByID("comp1img", Image.class)).setImage(new ResourceLocation("minecolonies:textures/entity/skills/small/" + primary.getComplimentary().name().toLowerCase(Locale.US) + ".png"), false);
                ((Text)windowCitizen.findPaneOfTypeByID("adverse1", Text.class)).setText(new TranslatableComponent("com.minecolonies.coremod.gui.citizen.job.skills." + primary.getAdverse().name().toLowerCase(Locale.US)).m_130946_(" (-10% XP)"));
                ((Image)windowCitizen.findPaneOfTypeByID("adverse1img", Image.class)).setImage(new ResourceLocation("minecolonies:textures/entity/skills/small/" + primary.getAdverse().name().toLowerCase(Locale.US) + ".png"), false);
            }
            Skill secondary = moduleView.getSecondarySkill();
            ((Text)windowCitizen.findPaneOfTypeByID("secondary", Text.class)).setText(new TranslatableComponent("com.minecolonies.coremod.gui.citizen.job.skills." + secondary.name().toLowerCase(Locale.US)).m_130946_(" (50% XP)"));
            ((Image)windowCitizen.findPaneOfTypeByID("secondaryimg", Image.class)).setImage(new ResourceLocation("minecolonies:textures/entity/skills/small/" + secondary.name().toLowerCase(Locale.US) + ".png"), false);
            if (secondary.getComplimentary() != null && secondary.getAdverse() != null) {
                ((Text)windowCitizen.findPaneOfTypeByID("comp2", Text.class)).setText(new TranslatableComponent("com.minecolonies.coremod.gui.citizen.job.skills." + secondary.getComplimentary().name().toLowerCase(Locale.US)).m_130946_(" (5% XP)"));
                ((Image)windowCitizen.findPaneOfTypeByID("comp2img", Image.class)).setImage(new ResourceLocation("minecolonies:textures/entity/skills/small/" + secondary.getComplimentary().name().toLowerCase(Locale.US) + ".png"), false);
                ((Text)windowCitizen.findPaneOfTypeByID("adverse2", Text.class)).setText(new TranslatableComponent("com.minecolonies.coremod.gui.citizen.job.skills." + secondary.getAdverse().name().toLowerCase(Locale.US)).m_130946_(" (-5% XP)"));
                ((Image)windowCitizen.findPaneOfTypeByID("adverse2img", Image.class)).setImage(new ResourceLocation("minecolonies:textures/entity/skills/small/" + secondary.getAdverse().name().toLowerCase(Locale.US) + ".png"), false);
            }
        } else {
            ((Image)windowCitizen.findPaneOfTypeByID("primaryimg", Image.class)).hide();
            ((Image)windowCitizen.findPaneOfTypeByID("comp1img", Image.class)).hide();
            ((Image)windowCitizen.findPaneOfTypeByID("adverse1img", Image.class)).hide();
            ((Image)windowCitizen.findPaneOfTypeByID("secondaryimg", Image.class)).hide();
            ((Image)windowCitizen.findPaneOfTypeByID("comp2img", Image.class)).hide();
            ((Image)windowCitizen.findPaneOfTypeByID("adverse2img", Image.class)).hide();
        }
    }

    private static enum HeartsEnum {
        EMPTY(Screen.f_93098_, 16, 0, 0, null, null),
        HALF_RED(Screen.f_93098_, 61, 0, 1, null, EMPTY),
        RED(Screen.f_93098_, 52, 0, 2, HALF_RED, EMPTY),
        HALF_GOLDEN(Screen.f_93098_, 169, 0, 3, null, RED),
        GOLDEN(Screen.f_93098_, 160, 0, 4, HALF_GOLDEN, RED),
        HALF_GREEN(WindowConstants.GREEN_BLUE_ICON, 8, 0, 5, null, GOLDEN),
        GREEN(WindowConstants.GREEN_BLUE_ICON, 0, 0, 6, HALF_GREEN, GOLDEN),
        HALF_BLUE(WindowConstants.GREEN_BLUE_ICON, 8, 8, 7, null, GREEN),
        BLUE(WindowConstants.GREEN_BLUE_ICON, 0, 8, 8, HALF_BLUE, GREEN);

        public final int X;
        public final int Y;
        public final int hpValue;
        public final HeartsEnum prevHeart;
        public final HeartsEnum halfHeart;
        public boolean isHalfHeart = false;
        public final ResourceLocation Image;

        private HeartsEnum(ResourceLocation heartImage, int x, int y, int hpValue, HeartsEnum halfHeart, HeartsEnum prevHeart) {
            this.Image = heartImage;
            this.X = x;
            this.Y = y;
            this.hpValue = hpValue;
            this.halfHeart = halfHeart;
            if (halfHeart == null) {
                this.isHalfHeart = true;
            }
            this.prevHeart = prevHeart;
        }
    }
}

